<?php
// login.php
session_start();
require_once __DIR__ . '/IPPAuth.php';
$api = new IPPAuth();
$message = '';

// if already logged in and token exists, try to validate automatically
if (!empty($_SESSION['final_token'])) {
    header('Location: dashboard.php'); exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if ($username === '' || $password === '') {
        $message = 'نام کاربری و رمز عبور را وارد کنید.';
    } else {
        $res = $api->login($username, $password);
        $_SESSION['last_login'] = $res;

        if (empty($res['meta']['status'])) {
            $message = 'عدم دریافت پاسخ از سرویس.';
        } elseif ($res['meta']['status'] === true) {
            $method = $res['data']['method'] ?? '';
            $token = $res['data']['token'] ?? '';

            if ($method === 'login') {
                $_SESSION['final_token'] = $token;
                $_SESSION['username'] = $username;
                header('Location: dashboard.php'); exit;
            } elseif ($method === 'sms' || $method === 'ga') {
                $_SESSION['tmp_token'] = $token;
                $_SESSION['username'] = $username;
                // Attempt to send SMS OTP (server may block rapid resends)
                $sendResp = $api->sendSmsOtp($token);
                $_SESSION['last_send_resp'] = $sendResp;
                // Redirect to confirm page regardless so user can enter OTP
                header('Location: confirm_otp.php'); exit;
            } else {
                $message = 'روش احراز پشتیبانی نمی‌شود: ' . htmlspecialchars($method);
            }
        } else {
            $message = $res['meta']['message'] ?? 'خطای لاگین';
        }
    }
}
?><!doctype html><html lang="fa" dir="rtl"><head><meta charset="utf-8"><title>ورود - IPPanel Edge</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
:root{--bg:#f6f8fb;--card:#fff;--accent:#0ea5a4;--muted:#64748b}
*{box-sizing:border-box;font-family:Tahoma, sans-serif}
body{background:var(--bg);margin:0;padding:20px;direction:rtl}
.container{max-width:920px;margin:40px auto}
.card{background:var(--card);padding:22px;border-radius:10px;box-shadow:0 8px 30px rgba(11,18,32,0.06)}
.grid{display:grid;grid-template-columns:1fr 360px;gap:20px}
.left{padding-right:10px}
.right{background:linear-gradient(180deg, rgba(14,165,164,0.06), transparent);padding:18px;border-radius:8px}
label{display:block;margin-bottom:6px;color:#111}
input{width:100%;padding:10px;margin-bottom:12px;border:1px solid #e2e8f0;border-radius:8px}
button{padding:10px 14px;border-radius:8px;border:none;background:var(--accent);color:#022;font-weight:600;cursor:pointer}
.msg{color:#c00;margin-bottom:12px}
.note{color:var(--muted);font-size:13px}
.header{display:flex;align-items:center;justify-content:space-between;margin-bottom:12px}
.logo{font-weight:700;color:var(--accent);font-size:20px}
</style>
</head><body><div class="container"><div class="card grid">
<div class="left">
<div class="header"><div><div class="logo">IPPanel Edge</div><div class="note">ورود کاربران</div></div></div>
<?php if($message): ?><div class="msg"><?=htmlspecialchars($message)?></div><?php endif; ?>
<form method="post" autocomplete="off">
<label>نام کاربری</label><input name="username" required>
<label>رمز عبور</label><input name="password" type="password" required>
<button type="submit">ورود</button>
</form>
</div>
<div class="right">
<h4>راهنما</h4>
<p class="note">با وارد کردن نام کاربری و رمز IPPanel خود وارد شوید. درصورت نیاز به احراز دو مرحله‌ای (OTP)، پس از ارسال پیامک به صفحهٔ وارد کردن کد هدایت خواهید شد.</p>
<?php if(isset($_SESSION['last_login'])): ?><details style="margin-top:12px"><summary>لاگ پاسخ ورود (برای دیباگ)</summary><pre style="background:#efefef;padding:8px;border-radius:6px"><?=htmlspecialchars(json_encode($_SESSION['last_login'], JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT))?></pre></details><?php endif; ?>
</div>
</div></div></body></html>