<?php
// dashboard.php - professional dashboard. Automatically checks token (hidden) on load.
// If token invalid -> logs out and redirects to login.
session_start();
require_once __DIR__ . '/IPPAuth.php';
$api = new IPPAuth();

if (empty($_SESSION['final_token'])) { header('Location: login.php'); exit; }

// automatic token check (silent)
$check = $api->checkToken($_SESSION['final_token']);
if (empty($check['meta']['status']) || $check['meta']['status'] !== true) {
    // invalid token -> clear session and redirect to login
    session_unset(); session_destroy();
    header('Location: login.php'); exit;
}

// At this point token is valid and $check['data'] contains user info
$user = $check['data'] ?? [];
// simple stats - these are placeholders (could be replaced by other Edge endpoints)
$stats = [
    'sent_today' => 0,
    'balance' => '—',
    'messages' => 0
];
?><!doctype html><html lang="fa" dir="rtl"><head><meta charset="utf-8"><title>داشبورد</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
:root{--bg:#f6f8fb;--card:#fff;--accent:#0ea5a4;--muted:#64748b}
*{box-sizing:border-box;font-family:Tahoma, sans-serif}
body{background:var(--bg);margin:0;padding:20px;direction:rtl}
.container{max-width:1200px;margin:30px auto;display:grid;grid-template-columns:260px 1fr;gap:20px}
.sidebar{background:#022b36;color:#fff;padding:16px;border-radius:10px;height:calc(100vh - 60px);position:sticky;top:20px}
.brand{font-weight:700;color:var(--accent);margin-bottom:12px}
.nav {margin-top:14px}
.nav a{display:block;padding:10px;border-radius:8px;color:#cfece9;text-decoration:none;margin-bottom:6px}
.card{background:var(--card);padding:18px;border-radius:10px;box-shadow:0 8px 30px rgba(11,18,32,0.06)}
.header{display:flex;justify-content:space-between;align-items:center;margin-bottom:12px}
.grid2{display:grid;grid-template-columns:repeat(3,1fr);gap:12px}
.stat{padding:12px;border-radius:8px;background:linear-gradient(180deg, #fff, #fbfbff);text-align:center}
.info small{color:var(--muted)}
.logout{background:#ef4444;color:#fff;padding:8px 12px;border-radius:8px;border:none;cursor:pointer}
</style>
</head><body><div class="container">
<div class="sidebar card">
<div class="brand">پنل مدیریت</div>
<div><strong><?=htmlspecialchars($user['name'] ?? $user['user_name'] ?? 'کاربر')?></strong></div>
<div style="font-size:13px;margin-top:8px;color:#cfece9">شناسه: <?=htmlspecialchars($user['user_id'] ?? '')?></div>
<div class="nav">
<a href="dashboard.php">داشبورد</a>
<a href="#">ارسال پیامک</a>
<a href="#">گزارش‌ها</a>
<a href="#">تنظیمات</a>
</div>
<form method="post" action="logout.php" style="margin-top:12px"><button class="logout" type="submit">خروج</button></form>
</div>

<div class="main">
<div class="header card"><div><h2 style="margin:0">داشبورد</h2><div style="color:var(--muted)">خوش آمدید، <?=htmlspecialchars($user['name'] ?? $user['user_name'] ?? '')?></div></div>
<div style="text-align:left"><small class="note">امنیت: توکن به‌صورت خودکار بررسی شد.</small></div></div>

<div class="card" style="margin-bottom:12px">
<div class="grid2">
<div class="stat"><h3><?=htmlspecialchars($stats['sent_today'])?></h3><small>پیام ارسال‌شده امروز</small></div>
<div class="stat"><h3><?=htmlspecialchars($stats['messages'])?></h3><small>تعداد پیام‌ها</small></div>
<div class="stat"><h3><?=htmlspecialchars($stats['balance'])?></h3><small>موجودی</small></div>
</div>
</div>

<div class="card">
<h3>اطلاعات حساب</h3>
<div class="info"><strong>نام کاربری:</strong> <?=htmlspecialchars($user['user_name'] ?? '')?><br><strong>نام:</strong> <?=htmlspecialchars($user['name'] ?? '')?><br><strong>وضعیت فروشنده:</strong> <?=(!empty($user['is_reseller'])?'بله':'خیر')?></div>
</div>

</div></div></body></html>