<?php
// IPPAuth.php - Edge Auth endpoints implementation (login, send_sms_otp, confirm_otp, check_token, logout)
class IPPAuth {
    private $base = "https://edge.ippanel.com/v1/api/acl/auth";

    private function request($endpoint, $data = [], $token = null) {
        $url = $this->base . $endpoint;
        $headers = ['Content-Type: application/json'];
        if ($token) $headers[] = 'Authorization: ' . $token;

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_POST => true,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_TIMEOUT => 15,
            CURLOPT_CONNECTTIMEOUT => 5,
        ]);
        $resp = curl_exec($ch);
        $err = curl_error($ch);
        $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($err) return ['meta'=>['status'=>false,'message'=>'curl_error: '.$err],'http_code'=>$http];
        $decoded = json_decode($resp, true);
        if ($decoded === null) return ['meta'=>['status'=>false,'message'=>'invalid_json_response'],'raw'=>$resp,'http_code'=>$http];
        return $decoded;
    }

    public function login($username, $password) {
        return $this->request('/login', ['username'=>$username,'password'=>$password]);
    }

    public function sendSmsOtp($temporaryToken) {
        return $this->request('/send_sms_otp', ['token'=>$temporaryToken]);
    }

    public function confirmOtp($temporaryToken, $otp) {
        return $this->request('/confirm_otp', ['token'=>$temporaryToken,'otp'=>$otp]);
    }

    public function checkToken($finalToken) {
        return $this->request('/check_token', [], $finalToken);
    }

    public function logout($finalToken) {
        return $this->request('/logout', [], $finalToken);
    }
}
?>